CREATE OR ALTER VIEW VWRELATORIOVENDAS(
    FEMPRESA,
    FNOMEFANTASIA,
    FRAZAOSOCIAL,
    FCPFCNPJ,
    FRGIE,
    FENDERECO,
    FNUMERO,
    FBAIRRO,
    FTELEFONE,
    FCIDADE,
    FIDPEDIDO,
    FDATA,
    FVENDEDOR,
    FCONDICAOPGTO,
    FIDDIASEMANA,
    FDIASEMANA,
    FHORA,
    FTOTALBRUTO,
    FDESCONTO,
    FTOTALLIQUIDO)
AS
select


Emp.codigo,
Emp.nomefantasia,
Emp.razaosocial,
Emp.cpfcnpj,
Emp.rgie,
Emp.endereco,
Emp.numero,
Emp.bairro,
Emp.telefone,
Cid.nome||' / '||Cid.uf as Cidade,
Vda.idpedido,
Vda.data,
lpad(Vdd.idcomissionado,2,'0')||'-'||Vdd.nome as Vendedor,
Pgt.descricao as CondicaoPgto,
extract(weekday from Vda.data) as IdDiaSemana,
case extract(weekday from Vda.data)
  when 0 then 'DOMINGO'
  when 1 then 'SEGUNDA - FEIRA'
  when 2 then 'TERCA - FEIRA'
  when 3 then 'QUARTA - FEIRA'
  when 4 then 'QUINTA - FEIRA'
  when 5 then 'SEXTA - FEIRA'
  when 6 then 'SABADO'
end  as DiaSemana,

lpad(extract(hour from Vda.hora),2 ,'0')||':00 e '||lpad(extract(hour from Vda.hora),2 ,'0')||':59'  as Hora,

case Nat.tipooperacao
  when 1  then Vda.totalbruto
  when 6  then (Vda.totalbruto)*(-1)
end as TotalBruto,

case Nat.tipooperacao
  when 1  then Vda.desconto*(-1)
  when 6  then Vda.desconto
end as Desconto,

case Nat.tipooperacao
  when 1  then Vda.totalliquido
  when 6  then (Vda.totalliquido)*(-1)
end as TotalLiquido

from

tgerempresa Emp
left join tvdapedido       Vda on  (vda.empresa             = Emp.codigo)
left join tgercidade       cid on  (cid.idcidade            = Emp.idcidade)
left join testnatureza     Nat on ((Nat.idnatureza          = Vda.idnatureza)and
                                   (Nat.movimentafinanceiro = 'S')and
                                   (Nat.precoutilizado      = 'PV'))
left join tvdacomissionado vdd on ((vdd.empresa             = vda.empresa)and
                                   (vdd.idcomissionado      = vda.idcomissionado))
left join tvdacondicao     Pgt on  (Pgt.idcondicao          = Vda.idcondicao)

where Nat.tipooperacao in (1,6) and
      Vda.status = 3

order by 2 desc
;
